#!/bin/bash

# Check if version argument is provided
if [ -z "$1" ]; then
  echo "Usage: $0 <version> [--no-cache]"
  exit 1
fi

VERSION=$1
NO_CACHE=""

# Check if --no-cache flag is provided
if [ "$2" == "--no-cache" ]; then
  NO_CACHE="--no-cache"
fi

# Build the Docker image
sudo docker build $NO_CACHE -t docker_image_validation -f src/compilation_baselines/Dockerfile_validation .

# Tag the Docker image with the provided version
docker tag docker_image_validation:latest sz904/validation:$VERSION

# Push the Docker image to the repository
docker push sz904/validation:$VERSION